#!/usr/bin/perl -w
#  script named render.pl
#  created 1999-08-09 by Mark Stock
#  1999-08-12 MJS  refer to files in ~/bin/etc
#  1999-08-13 MJS  look in local dir for scene.rad, scene.vp first
#    do not reconvert 000.rad each step, check first
#  1999-09-17 MJS  frd files have new names
#  2000-01-24 MJS  New radiance binaries in /usr/local/radiance/bin
#  2000-02-21 MJS  Major rewrite, includes scalar, particles, and
#    a superfly subroutine for trimming triangles
#  2000-04-06 MJS  Added flag to toggle deletion of .rad and .pic files
#  2000-04-07 MJS  added scaledown for the pfilt process
#  2000-11-27 MJS  modified to render these new .rad files from vort3d
#  2001-01-12 MJS  modified to render rad files from grav3d
#
# this script read .tin front files and makes JPG images from each
#
# Copyright 2000,2001,2002 Mark Stock
#
# render.pl is part of part3d
#
# part3d is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# part3d is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with part3d; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# parameters
$exposure = 1.0;
# scaledown is an integer factor to scale the final rendering down by
$scaledown = 2;
$makegifs = 1;
$makejpgs = 0;
$makeppms = 0;
$makebmps = 0;
$makepngs = 0;
$delrads = 0;
$ziprads = 0;
$delpics = 1;


# if no command-line args, assume bounds and check them
$startframe = 0;
$endframe = 999;
if ($ARGV[0]) {
   $startframe = $ARGV[0];
   if ($ARGV[1]) {
      $endframe = $ARGV[1];
   }
}

for ($frameno=$startframe; $frameno<=$endframe; $frameno++) {

   $framename1 = sprintf "output%3.3d", ${frameno};
   $outname = sprintf "img%3.3d", ${frameno};

   if (-e "${framename1}.rad" && ! -e "${outname}.gif") {

      print "\ncreating ${outname}.gif from ${framename1}.rad\n" ;

      $filelist = "scene.rad ${framename1}.rad";

      # render

      print "oconv ${filelist} > scene.oct\n";
      system "oconv ${filelist} > scene.oct";

      if (-e "./scene.vp") {
         print "rpict \@scene.vp -t 60 scene.oct > ${outname}.pic\n";
         system "rpict \@scene.vp -t 60 scene.oct > ${outname}.pic";
      } else {
         print "Need scene.vp file to run!\n";
         exit;
      }

      # post-processing

      # pfilt -1 -e +2 img400.pic | ra_ppm | pnmscale 0.2 | ppmtogif > img21.gif
      $scale = 1.0/${scaledown};
      #$command = "pfilt -1 -e +${exposure} ${outname}.pic | ra_ppm | pnmscale ${scale} > ${outname}.ppm\n";
      $command = "pfilt -1 -e +${exposure} -r 0.7 -x /${scaledown} -y /${scaledown} ${outname}.pic | ra_ppm > ${outname}.ppm\n";
      print $command;
      system $command;
      # print "pfilt -1 -e +${exposure} ${outname}.pic | ra_ppm | pnmscale ",1.0/${scaledown}," > ${outname}.ppm\n";
      # system "pfilt -1 -e +${exposure} ${outname}.pic | ra_ppm | pnmscale ",1.0/${scaledown}," > ${outname}.ppm\n";
      # print "pfilt -1 -e +${exposure} -x /${scaledown} -y /${scaledown} ${outname}.pic | ra_ppm > ${outname}.ppm\n";
      # system "pfilt -1 -e +${exposure} -x /${scaledown} -y /${scaledown} ${outname}.pic | ra_ppm > ${outname}.ppm";
      if ($makegifs) {
         print "ppmquant 256 ${outname}.ppm | ppmtogif > ${outname}.gif\n";
         system "ppmquant 256 ${outname}.ppm | ppmtogif > ${outname}.gif";
      }
      if ($makepngs) {
         system "ppmquant 256 ${outname}.ppm | pnmtopng > ${outname}.png";
      }
      if ($makebmps) {
         system "ppmquant 256 ${outname}.ppm | ppmtobmp -windows > ${outname}.bmp";
      }
      if ($makejpgs) {
         system "cjpeg -quality 90 ${outname}.ppm > ${outname}.jpg";
      }
      if (!$makeppms) {
         system "rm ${outname}.ppm";
      }
      if ($delpics) {
         system "rm ${outname}.pic";
      }
      if ($delrads) {
         $filelist = "${framename1}.rad";
         system "rm ${filelist}";
      }
      if ($ziprads) {
         $filelist = "${framename1}.rad";
         system "gzip ${filelist}";
      }
   }
}

if ($makegifs) {
   print "Try running the following command:\n";
   #print "gifsicle --delay 10 --colors 256 img*gif > mov_frd.gif\n";
   print "gifsicle img???.gif > mov_.gif\n";
} else {
   print "\n";
}

exit;

