#!/bin/sh
#
# hfcreate.sh - a script for creating a nice landscape scene in Radiance

# some variables

debug='n'
write_rad='y'
use_simp='y'
tmp=/tmp

if [ ${debug} = 'y' ]
then
   d="# "		# do or not do
   ocean=0
   width=200
   height=200
else
   d=""
fi

if [ ! `which scape | awk -F/ '{print $NF}'` = 'scape' ]
then
   echo "Can't find scape software, use_simp = n"
   use_simp='n'
fi

# act on user input

if [ $1 ]
then
   infile=$1		# the name of the input file
   # prepare the input file
   #if [ `echo ${infile} | awk -F. '{print $NF}'` = "gz" ]
   #then
      #gunzip ${infile}
      #infile=
   #fi
   #if [ `echo ${infile} | awk -F. '{print $NF}'` = "dem" ]
   if [ `echo ${infile} | awk -F. '{print $NF}'` = "pgm" ]
   then
      inroot=`basename ${infile} .pgm`
      inroot=`basename ${inroot} _hf`
      # Get the data on the PGM
      pnmfile ${infile} > ${tmp}/temp.txt
      width=`cat ${tmp}/temp.txt | awk '{print $4}'`
      height=`cat ${tmp}/temp.txt | awk '{print $6}'`
      maxval=`cat ${tmp}/temp.txt | awk '{print $8}'`
      echo "width is ${width} , height is ${height} , max alt is ${maxval}"
   else
      echo "hfcreate only operates on .pgm files, make sure the file is"
      echo "   a .pgm and has the correct extension."
      echo ""
      exit
   fi
else
   echo "Usage: hfcreate input [outputroot] [length units per height unit]"
   echo "  The input can only be a .pgm, for now"
   echo "  The last two args are optional, but you need the 2nd if you must specify the 3rd."
   echo ""
   exit
fi

if [ $2 ]
then
   outroot=$2		# the root name of all output files
else
   outroot=${inroot}
fi
inroot=${outroot}

if [ $3 ]
then
   # scale is user-defined
   hscale=$3
   iscale=`ev "1/${hscale}"`
else
   # scale must be deduced
   if [ ${height} -lt 600 ]
   then
      echo "Input data is USGS quadrangle, 30m per cell"
      iscale=0.03333
      hscale=30
   else
      echo "Input data is USGS 1-degree DEM, 92m per cell"
      iscale=0.01087
      hscale=92
   fi
fi

if [ $4 ]
then
   # set low altitude to this altitude
   low_bound=$4
else
   low_bound=-1000
fi

if [ $5 ]
then
   # set high altitude to this altitude
   hi_bound=$5
else
   hi_bound=10000
fi


echo
# Start creating the directory and files

if [ -d ${outroot} ]
then
   echo "Directory ${outroot} already exists, using it."
else
   echo "Making directory ${outroot}"
   echo mkdir ${outroot}
   ${d}mkdir ${outroot}
fi
outroot="${outroot}/${outroot}"

${d}cp ${infile} ${outroot}_hf.pgm
echo


# Erode it a little to find the rivers, if a river map does not already exist

if [ ! -r ${outroot}_rv.pgm ]
then
   echo "No river map exists, making one..."
   # if [ -x `which erode` ]
   # then
      echo "erode ${outroot}_hf.pgm 100 2 0.01 1.0 0.05 2.0 2.0 0.0 1.0 200.0 > ${tmp}/erode_out.txt"
      ${d}../er1u/erode ${outroot}_hf.pgm 100 2 0.01 1.0 0.05 2.0 2.0 0.0 1.0 200.0 > ${tmp}/erode_out.txt
      echo mv uphill01.pgm ${outroot}_rv.pgm
      ${d}mv uphill01.pgm ${outroot}_rv.pgm
      ${d}rm topo* uphill*
   #else
      #echo "Program erode does not exist, will not compute or use a river map."
   #fi
else
   echo "Using existing river map."
fi
echo


# check for lake map

if [ ! -r ${outroot}_lk.pgm ]
then
   echo "No lake map, will have to make do without one."
else
   echo "Using existing lake map."
fi
echo


# add a beach and water detail
#${d}hfbeach


# compute the imagemap
if [ ! -r ${outroot}_im.pic ]
then
   if [ ! -r ${outroot}_im.ppm ]
   then
      echo "No image map exists, making one..."
      if [ -r ${outroot}_lk.pgm ]
      then
         echo "hfcolor -in ${outroot}_hf.pgm -out ${tmp}/img -e -s 5 -k -tree -bounds ${low_bound} ${hi_bound} -r ${outroot}_rv.pgm -l ${outroot}_lk.pgm > ${tmp}/temp.txt"
         ${d}hfcolor -in ${outroot}_hf.pgm -out ${tmp}/img -e -s 5 -k -tree -bounds ${low_bound} ${hi_bound} -r ${outroot}_rv.pgm -l ${outroot}_lk.pgm > ${tmp}/temp.txt
      else
         echo "hfcolor -in ${outroot}_hf.pgm -out ${tmp}/img -e -s 5 -k -tree -bounds ${low_bound} ${hi_bound} -r ${outroot}_rv.pgm > ${tmp}/temp.txt"
         ${d}hfcolor -in ${outroot}_hf.pgm -out ${tmp}/img -e -s 5 -k -tree -bounds ${low_bound} ${hi_bound} -r ${outroot}_rv.pgm > ${tmp}/temp.txt
      fi
      #echo mv ${tmp}/img.ppm ${outroot}_im.ppm
      ${d}mv ${tmp}/img.ppm ${outroot}_im.ppm
      #echo "ra_ppm -r ${outroot}_im.ppm > ${outroot}_im.pic"
      ${d}ra_ppm -r ${outroot}_im.ppm > ${outroot}_im.pic
      #echo mv ${tmp}/img.pgm ${outroot}_tm1.pgm
      ${d}mv ${tmp}/img.pgm ${outroot}_tm1.pgm
      rm ${outroot}_tm.pgm
      #echo "ocean=`grep ocean_level ${tmp}/temp.txt | awk '{print $3}'`"
      if [ ${debug} != 'y' ]
      then
         ocean=`grep ocean_level ${tmp}/temp.txt | awk '{print $3}'`
      fi
   else
      echo "Using existing image map (.ppm)"
      #echo "ra_ppm -r ${outroot}_im.ppm > ${outroot}_im.pic"
      ${d}ra_ppm -r ${outroot}_im.ppm > ${outroot}_im.pic
   fi
else
   echo "Using existing image map (.pic)"
fi
echo


# blur tree map
if [ ! -r ${outroot}_tm.pgm ]
then
   echo "No tree map exists, using the one from hfcolor..."
   echo pgmblob -in ${outroot}_tm1.pgm -out ${outroot}_tm.pgm -sub ${outroot}_rv.pgm -n 24
   ${d}pgmblob -in ${outroot}_tm1.pgm -out ${outroot}_tm.pgm -sub ${outroot}_rv.pgm -n 24
else
   echo "Using existing tree map."
fi
echo


# write trees
if [ ${write_rad} = 'y' ]
then
 if [ ! -r ${outroot}_tr.rad ]
 then
   echo "No Radiance tree file exists, making one..."
   echo hfplant -in ${outroot}_hf.pgm -tree ${outroot}_tm.pgm -out ${outroot}_tr.rad -scale 30.0 -ocean ${ocean}
   #${d}hfplant -in ${outroot}_hf.pgm -tree ${outroot}_tm.pgm -out ${outroot}_tr.rad -scale 30.0 -ocean ${ocean}
   ${d}hfplant -in ${outroot}_hf.pgm -tree ${outroot}_tm.pgm -out ${outroot}_tr.rad -scale 30.0
 else
   echo "Using existing Radiance tree file."
 fi
fi
echo


# Use scape-1.2 surface simplification, or use gensurf to make the .rad file
if [ ${write_rad} = 'y' ]
then
 if [ ${use_simp} = 'y' ]
 then
  if [ ! -r ${outroot}_tri.rad ]
  then
   echo "No triangle mesh Radiance file exists, making one..."
   # Use surface simplification (20000 polygons, roughly)
   echo pgm2stm -in ${infile} -out ${tmp}/hf.stm
   ${d}pgm2stm -in ${infile} -out ${tmp}/hf.stm
   echo scape ${tmp}/hf.stm -datadep -npoint 10000
   ${d}scape ${tmp}/hf.stm -datadep -npoint 10000
   # echo mv out.tin ${tmp}/tri.tin
   # ${d}mv out.tin ${tmp}/tri.tin
   echo "tinscale out.tin -h ${hscale} > ${tmp}/tri.tin"
   ${d}tinscale out.tin -h ${hscale} > ${tmp}/tri.tin
   echo tin2rad -in ${tmp}/tri.tin -out ${outroot}_tri.rad
   ${d}tin2rad -in ${tmp}/tri.tin -out ${outroot}_tri.rad
   rm out.tin
   rm ${tmp}/tri.tin
   rm ${tmp}/hf.stm
  else
   echo "Using existing triangle mesh Radiance file."
  fi

 else

   # don't do surface simplification, just use the heightfield
   # Check the PGMs size, and scale the image accordingly

   # if [ width -gt 200 || height -gt 200 ]
   if [ `ev "${width}*${height}"` -gt 40000 ]
   then
      # scale it down to 80k triangles or less
      echo pnmscale `ev "sqrt(40000/${width}/${height})"` ${infile} into ${outroot}_hf.pgm
      ${d}pnmscale `ev "sqrt(40000/${width}/${height})"` ${infile} > ${outroot}_hf.pgm
   # else
      # use it as-is
   fi

   echo hf2rad -in ${outroot}_hf.pgm -out ${outroot}_sc -ocean ${ocean}
   ${d}hf2rad -in ${outroot}_hf.pgm -out ${outroot}_sc -ocean ${ocean}
 fi
fi
echo


# create the .rad files to link it all together
# before writing it, remove the old one
rm ${outroot}_sc.rad
echo "Writing the Radiance description of the scene..."
echo

echo "# Radiance input file for heightfield" >> ${outroot}_sc.rad
echo >> ${outroot}_sc.rad
echo "void colorpict image_pat" >> ${outroot}_sc.rad
echo "13 red green blue ${inroot}_im.pic picture.cal pic_u pic_v" >> ${outroot}_sc.rad
if [ ${height} -gt ${width} ]
then
   scale=`ev "${width}*${hscale}"`
else
   scale=`ev "${height}*${hscale}"`
fi
shift=`ev "-${hscale}/2.0"`
echo "   -s ${scale} -t ${shift} ${shift} 0.0" >> ${outroot}_sc.rad
echo "0" >> ${outroot}_sc.rad
echo "0" >> ${outroot}_sc.rad
echo >> ${outroot}_sc.rad
echo "image_pat plastic ground_mat" >> ${outroot}_sc.rad
echo "0" >> ${outroot}_sc.rad
echo "0" >> ${outroot}_sc.rad
echo "5  1.0  1.0  1.0  0.0  0.05" >> ${outroot}_sc.rad
echo >> ${outroot}_sc.rad
echo >> ${outroot}_sc.rad
echo "# Radiance description of a nice evening sky" >> ${outroot}_sc.rad
echo >> ${outroot}_sc.rad
echo "!cat ../lib/sky.rad" >> ${outroot}_sc.rad
echo "" >> ${outroot}_sc.rad
echo "" >> ${outroot}_sc.rad
echo "" >> ${outroot}_sc.rad
