#!/bin/sh
#
# taritup.sh - a script to wrap up hftools

dirn=`pwd | awk -F/ '{print $NF}'`
suffix=`date '+_%Y-%m-%e'`

cd ..

if [ -r ./hftools.tar ]
then
   echo "hftools.tar exists, backing it up..."
   mv hftools.tar hftools.tar${suffix}
fi

tar -cvf hftools.tar ${dirn}/*.c ${dirn}/*.h ${dirn}/?O* ${dirn}/Makefile ${dirn}/*.sh ${dirn}/lib

if [ -r ./hftools.tar.gz ]
then
   echo "hftools.tar.gz exists, backing it up..."
   mv hftools.tar.gz hftools.tar.gz${suffix}
fi

gzip hftools.tar

echo "hftools.tar.gz is ready to go!"
