/***********************************************************
 *
 *  tinscale.c - Scale coordinates of a specified TIN file
 *
 *  Mark J. Stock, Aug 31, 1998, version 0.0
 *
 ***********************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define TRUE 1

void main(int argc,char **argv) {

   int i, num_tri = 0;
   int scale_x = 0;
   int scale_y = 0;
   int scale_z = 0;
   double x_scale = 1;
   double y_scale = 1;
   double z_scale = 1;
   double xp,yp,zp;
   char xs[20],ys[20],zs[20];
   char infile[80];
   char progname[80];
   char onechar;
   char twochar[2];
   char sbuf[128];
   FILE *fp;

   /* Parse command-line args */
   (void) strcpy(progname,argv[0]);
   if (argc < 2) (void) Usage(progname,0);
   if (strncmp(argv[1], "-help", 2) == 0)
      (void) Usage(progname,0);
   (void) strcpy(infile,argv[1]);
   for (i=2; i<argc; i++) {
      if (strncmp(argv[i], "-x", 2) == 0) {
         x_scale = atof(argv[++i]); 
         scale_x = TRUE; }
      else if (strncmp(argv[i], "-y", 2) == 0) {
         y_scale = atof(argv[++i]); 
         scale_y = TRUE; }
      else if (strncmp(argv[i], "-z", 2) == 0) {
         z_scale = atof(argv[++i]); 
         scale_z = TRUE; }
      else if (strncmp(argv[i], "-h", 2) == 0) {
         x_scale = atof(argv[++i]); 
         y_scale = x_scale;
         scale_x = TRUE;
         scale_y = TRUE; }
      else
         (void) Usage(progname,0);
   }


   /* open the .tin file for reading */
   fp = fopen(infile,"r");
   if (fp==NULL) {
      fprintf(stderr,"Could not open input file %s\n",infile);
      exit(0);
   }
   /* fprintf(stderr,"Opening file %s\n",infile); */


   /* read the input file and update statistics */

   while (fread(&onechar,sizeof(char),1,fp) == 1) {

      if (onechar == '#') {
         /* read a comment line */
         fscanf(fp,"%[^\n]",sbuf);	/* read comment beyond '#' */
         fscanf(fp,"%[\n]",twochar);	/* read newline */
         fprintf(stdout,"#%s\n",sbuf);	/* write comment */

      } else if (onechar == 't') {
         /* read a triangle line */
         fprintf(stdout,"t");
         for (i=0; i<3; i++) {
            fscanf(fp,"%s %s %s",xs,ys,zs);
            xp = atof(xs);
            yp = atof(ys);
            zp = atof(zs);
            if (scale_x) xp *= x_scale;
            if (scale_y) yp *= y_scale;
            if (scale_z) zp *= z_scale;
            fprintf(stdout," %g %g %g",xp,yp,zp);
         }
         num_tri++;
         fscanf(fp,"%[\n]",twochar);	/* read newline */
         fprintf(stdout,"\n");

      } else {
         /* if its not identifiable, skip it, do not scale, do not write */
         fscanf(fp,"%[^\n]",sbuf);	/* read line beyond first char */
         fscanf(fp,"%[\n]",twochar);	/* read newline */

      }
   }

   /* write statistics */
   fprintf(stdout,"# %s: TIN ASCII file, %d triangles\n",infile,num_tri);

}


/*
 * This function writes basic usage information to stderr,
 * and then quits. Too bad.
 */
int Usage(char progname[80],int status) {

   /* Usage for tinscale */
   static char **cpp, *help_message[] =
   {
       "where [-options] are one or more of the following:",
       "   -x val      sets scaling in x-direction",
       "   -y val      sets scaling in y-direction",
       "   -z val      sets scaling in z-direction",
       "   -h val      sets scaling in horizontal (x and y) directions)",
       "   -help       (in place of infile) returns this help information",
       " ",
       "Options may be abbreviated to an unambiguous length (duh).",
       "Output is to stdout",
       NULL
   };

   fprintf(stderr, "usage:\n  %s infile [-options]\n\n", progname);
   for (cpp = help_message; *cpp; cpp++)
      fprintf(stderr, "%s\n", *cpp);
   exit(status);
   return(0);
}
