/***********************************************************
 *
 *  tinfile.c - Return data for a specified TIN file
 *
 *  Mark J. Stock, Aug 31, 1998, version 0.0
 *
 ***********************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

void main(int argc,char **argv) {

   int i, num_tri;
   double min_x,max_x,min_y,max_y,min_z,max_z;
   double xp,yp,zp;
   char xs[20],ys[20],zs[20];
   char infile[80];
   char progname[80];
   char onechar;
   char twochar[2];
   char sbuf[128];
   FILE *fp;

   /* Parse command-line args */
   (void) strcpy(progname,argv[0]);
   if (argc < 2) (void) Usage(progname,0);
   if (strncmp(argv[1], "-help", 2) == 0)
      (void) Usage(progname,0);
   (void) strcpy(infile,argv[1]);

   /* set all initial values */
   min_x = 10000;
   max_x = 0;
   min_y = 10000;
   max_y = 0;
   min_z = 10000;
   max_z = 0;
   num_tri = 0;

   /* open the .tin file for reading */
   fp = fopen(infile,"r");
   if (fp==NULL) {
      fprintf(stderr,"Could not open input file %s\n",infile);
      exit(0);
   }
   /* fprintf(stderr,"Opening file %s\n",infile); */


   /* read the input file and update statistics */

   while (fread(&onechar,sizeof(char),1,fp) == 1) {

      if (onechar == '#') {
         /* read a comment line */
         fscanf(fp,"%[^\n]",sbuf);  /* read comment beyond '#' */
         fscanf(fp,"%[\n]",twochar);  /* read newline */
         fprintf(stderr,"   #%s\n",sbuf);            /* display comment */

      } else if (onechar == 't') {
         /* read a triangle line */
         /* fprintf(stderr,"tri number %d\n",num_tri); */
         for (i=0; i<3; i++) {
            /* fscanf(fp," %lf %lf %lf",xp,yp,zp); */
            fscanf(fp,"%s %s %s",xs,ys,zs);
            xp = atof(xs);
            yp = atof(ys);
            zp = atof(zs);
            /* fprintf(stderr,"   node %lf %lf %lf\n",xp,yp,zp); */
            /* fflush(stderr); */
            if (xp < min_x) min_x = xp;
            if (xp > max_x) max_x = xp;
            if (yp < min_y) min_y = yp;
            if (yp > max_y) max_y = yp;
            if (zp < min_z) min_z = zp;
            if (zp > max_z) max_z = zp;
         }
         num_tri++;
         fscanf(fp,"%[\n]",twochar);  /* read newline */

      } else {
         /* if its not identifiable, skip it */
         fscanf(fp,"%[^\n]",sbuf);  /* read line beyond first char */
         fscanf(fp,"%[\n]",twochar);  /* read newline */

      }
   }

   /* write statistics */
   fprintf(stdout,"%s: TIN ASCII file, %d triangles\n",infile,num_tri);
   fprintf(stdout,"x %lf %lf\n",min_x,max_x);
   fprintf(stdout,"y %lf %lf\n",min_y,max_y);
   fprintf(stdout,"z %lf %lf\n\n",min_z,max_z);


}


/*
 * This function writes basic usage information to stderr,
 * and then quits. Too bad.
 */
int Usage(char progname[80],int status) {

   /* Usage for tinfile */
   static char **cpp, *help_message[] =
   {
       "where infile is the name of a .tin triangle input format file",
       "if -help is used as the infile, this help information is written",
       " ",
       "Options may be abbreviated to an unambiguous length.",
       NULL
   };

   fprintf(stderr, "usage:\n  %s infile\n\n", progname);
   for (cpp = help_message; *cpp; cpp++)
      fprintf(stderr, "%s\n", *cpp);
   exit(status);
   return(0);
}
